class Scene4 extends Phaser.Scene{
   
    constructor(){
        super("end");
    }

    

    create(){

        var centerX = this.cameras.main.centerX; // get the center x coordinate of the game window
        var centerY = this.cameras.main.centerY; // get the center y coordinate of the game window

        this.endSound = this.sound.add('endSnd');
        this.endSound.play();

        this.idle_background=this.add.image(centerX,680,"backgroundEnd");
        this.idle_background.setDisplaySize(1720, 1080); // Cambia el tamaño a 1920x1080

        this.scoreText=this.add.text(centerX, 760, this.game.global.score, {
            font: "170px JohnsonDisplay-Medium",
            fill: "black",
            align: "center",
            wordWrap: { width: 600 }
           });
           this.scoreText.setOrigin(0.5, 0.5);

        this.play_button=this.add.image(centerX,1500,"endButton");
        this.play_button.setAlpha(1);
        this.play_button.setInteractive({ useHandCursor: true });

        
        this.play_button.on('pointerup', function (pointer) {
		this.changeScene();
        }, this);

                // Display the first question, delay if fow get time to load the fonts 4 the first text load.
                this.time.delayedCall(100, this.updateScoretext, [this.actualQuestion], this);
                this.time.delayedCall(100, this.sendDataToGameAnalytics, [this.actualQuestion], this);
                this.tweens.add({
            targets: this.play_button,
            scale: 1.1, // Aumenta el tamaño en un 10%
            duration: 800, // Duración de 800 ms
            yoyo: true, // Regresa al tamaño original
            repeat: -1, // Repite indefinidamente
            ease: 'Sine.easeInOut' // Suaviza el efecto
        });


    }


    updateScoretext(){
        this.scoreText.text=this.game.global.score;
    }
    
    changeScene(){
        this.scene.start('idle');
    }

}
